/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.blocks.entities.BlockEntityHydrothermalVent;
import org.betterx.betterend.registry.EndBlocks;
import org.jetbrains.annotations.Nullable;

public class HydrothermalVentBlock
extends BaseBlockNotFull.Stone
implements EntityBlock,
LiquidBlockContainer,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty ACTIVATED = BlockProperties.ACTIVE;
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public HydrothermalVentBlock() {
        super(BehaviourBuilders.createStone().m_60918_(SoundType.f_56742_).m_60910_().m_60999_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, ACTIVATED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return false;
    }

    public boolean m_7361_(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        return false;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        state = world.m_8055_(pos.m_7495_());
        return state.m_60713_(EndBlocks.SULPHURIC_ROCK.stone);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            return Blocks.f_49990_.m_49966_();
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && facing == Direction.UP && neighborState.m_60713_(Blocks.f_49990_)) {
            world.m_186460_(pos, (Block)this, 20);
        }
        return state;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level worldAccess = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldAccess.m_6425_(blockPos).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityHydrothermalVent(pos, state);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockPos up = pos.m_7494_();
        if (world.m_8055_(up).m_60713_(Blocks.f_49990_)) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)up, (Block)EndBlocks.VENT_BUBBLE_COLUMN);
            world.m_186460_(up, EndBlocks.VENT_BUBBLE_COLUMN, 5);
        }
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (world instanceof ServerLevel && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && world.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_)) {
            this.m_213897_(state, (ServerLevel)world, pos, world.f_46441_);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.m_214162_(state, world, pos, random);
        if (!((Boolean)state.m_61143_((Property)ACTIVATED)).booleanValue() && random.m_188499_()) {
            double x = (double)pos.m_123341_() + random.m_188500_();
            double y = (double)pos.m_123342_() + 0.9 + random.m_188500_() * 0.3;
            double z = (double)pos.m_123343_() + random.m_188500_();
            world.m_7106_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BlockEntityHydrothermalVent::tick;
    }
}

